/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class HudRenderHelper {
    public static void renderHudItems(PoseStack matrixStack, MultiBufferSource buffer, List<Pair<ItemStack, String>> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, Direction orientation, double x, double y, double z, float scale) {
        matrixStack.m_85836_();
        if (hudPlacement == HudPlacement.HUD_FRONT) {
            matrixStack.m_85837_((double)((float)x + 0.5f), (double)((float)y + 0.75f), (double)((float)z + 0.5f));
        } else if (hudPlacement == HudPlacement.HUD_CENTER) {
            matrixStack.m_85837_((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        } else {
            matrixStack.m_85837_((double)((float)x + 0.5f), (double)((float)y + 1.75f), (double)((float)z + 0.5f));
        }
        Quaternion quaternion = Minecraft.m_91087_().m_91290_().m_114470_();
        switch (hudOrientation) {
            case HUD_SOUTH: {
                matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -HudRenderHelper.getHudAngle(orientation), true));
                break;
            }
            case HUD_TOPLAYER_HORIZ: {
                matrixStack.m_85845_(quaternion);
                matrixStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)3.14159f, (float)0.0f));
                break;
            }
            case HUD_TOPLAYER: {
                matrixStack.m_85845_(quaternion);
                matrixStack.m_85845_(Quaternion.m_175228_((float)0.0f, (float)3.14159f, (float)0.0f));
            }
        }
        if (hudPlacement == HudPlacement.HUD_FRONT || hudPlacement == HudPlacement.HUD_ABOVE_FRONT) {
            matrixStack.m_85837_(0.0, -0.25, 0.4624999761581421);
        } else if (hudPlacement != HudPlacement.HUD_CENTER) {
            matrixStack.m_85837_(0.0, -0.25, -0.03749999403953552);
        }
        HudRenderHelper.renderText(matrixStack, buffer, Minecraft.m_91087_().f_91062_, messages, 11, scale);
        matrixStack.m_85849_();
    }

    public static void renderHud(PoseStack stack, MultiBufferSource buffer, List<String> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, Direction orientation, double x, double y, double z, float scale) {
        HudRenderHelper.renderHudItems(stack, buffer, messages.stream().map(s -> Pair.of((Object)ItemStack.f_41583_, (Object)s)).collect(Collectors.toList()), hudPlacement, hudOrientation, orientation, x, y, z, scale);
    }

    private static float getHudAngle(Direction orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            f3 = switch (orientation) {
                case Direction.NORTH -> 180.0f;
                case Direction.WEST -> 90.0f;
                case Direction.EAST -> -90.0f;
                default -> 0.0f;
            };
        }
        return f3;
    }

    private static void renderText(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, List<Pair<ItemStack, String>> messages, int lines, float scale) {
        matrixStack.m_85837_(-0.5, 0.5, (double)0.07f);
        float f3 = 0.0075f;
        matrixStack.m_85841_(f3 * scale, -f3 * scale, f3);
        HudRenderHelper.renderLog(matrixStack, buffer, fontrenderer, messages, lines);
    }

    private static void renderLog(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, List<Pair<ItemStack, String>> messages, int lines) {
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        for (Pair<ItemStack, String> pair : messages) {
            ItemStack stack = (ItemStack)pair.getLeft();
            String s = (String)pair.getRight();
            if (i >= logsize - lines && currenty + height <= 124) {
                String prefix = "";
                if (!stack.m_41619_()) {
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(14.0, (double)((float)currenty + 4.0f), 0.0);
                    matrixStack.m_85841_(10.0f, -10.0f, 16.0f);
                    ItemRenderer itemRender = Minecraft.m_91087_().m_91291_();
                    BakedModel ibakedmodel = itemRender.m_174264_(stack, (Level)Minecraft.m_91087_().f_91073_, null, 1);
                    itemRender.m_115143_(stack, ItemTransforms.TransformType.GUI, false, matrixStack, buffer, 0xF000F0, OverlayTexture.f_118083_, ibakedmodel);
                    prefix = "    ";
                    matrixStack.m_85849_();
                }
                fontrenderer.m_92811_(fontrenderer.m_92834_(prefix + s, 115), 7.0f, (float)currenty, 0xFFFFFF, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, 0xF000F0);
                currenty += height;
            }
            ++i;
        }
    }

    public static enum HudPlacement {
        HUD_ABOVE,
        HUD_ABOVE_FRONT,
        HUD_FRONT,
        HUD_CENTER;

    }

    public static enum HudOrientation {
        HUD_SOUTH,
        HUD_TOPLAYER_HORIZ,
        HUD_TOPLAYER;

    }
}

